
# This creates a palette of colours fading from blue to red
colfunc <- colorRampPalette(c("blue", "red"))
colfunc(250)


########################################## Grid example #####################
#a sequence of 250 increasing values between 0 and 1 is created
pgrid<-seq(from=0, to=1, length.out = 250)
#The prior distributes the probability across the range 0 to 1
prior<-rep((1/250),250)
#This pots the prior. The graph type b includes dots across the line, and these dots are being...
#...coloured according to the palette from blue to red
plot(pgrid, prior, type="b", col=colfunc(250), xlab="Proportion of Red", ylab="Prior prob.", cex.lab = 1.5, pch = 19)
#Calculate the likelihood of the data (3/5)  according to a binomial function
likelihood<-dbinom(3, size=5, prob=pgrid)
#Calculate the Unstandardized posterior
unstpost<-likelihood*prior
#Calculate the standardized posterior
posterior<-unstpost/sum(unstpost)
#Plot the distribution of the posterior
plot(pgrid, posterior, type="b", xlab="Proportion of Red", ylab="Posterior prob.", col=colfunc(250), 
      pch = 19 , cex.lab = 1.5,)
#Draw 10k random samples from the posterior
samples<-sample(pgrid, prob=posterior, size=1e4, replace=TRUE)
#Plot these random samples
plot(samples, xlab="sample number", ylab="Posterior prob." )
#Represent their probability distribution, and their quantiles 
dens(samples,  )
quantile(samples, c(0.1, 0.9))

#### Example n2 ####

#The posterior in the previous example now becomes the prior
prior<-posterior
#Remove the previous likelihood and posteriors from R environment
rm(likelihood, unstpost, posterior)
# Calculate the likelihood of the new data (29/50)
likelihood<-dbinom(29, size=50, prob=pgrid)
# Calculate the unstandardised and standardised posterior
unstpost<-likelihood*prior
posterior<-unstpost/sum(unstpost)
#Plot this new posterior 
plot(pgrid, posterior, type="b", xlab="Proportion of Red", ylab="Posterior prob.", col=colfunc(250), 
     pch = 19 , cex.lab = 1.5,)

#### Sample from the posterior ####

#Set seed to ensure the example is replicable
set.seed(20863)
#Draw 10k random samples from the posterior
samples<-sample(pgrid, prob=posterior, size=1e4, replace=TRUE)
#plot these samples and colour them according their p value
plot( samples, xlab="sample number", ylab="Proportion of Red", col=colfunc(105)[factor(samples)], pch = 19  )
#Add lines to represent the thresholds of the mass of the credible intervals 
abline(h=.4940, lty=2, lwd=6, col="blue4")
abline(h=.6627, lty=2, lwd=6, col="firebrick4")

